/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.interceptor.InterceptorMethodParametersResolver;
import br.com.caelum.vraptor.interceptor.SimpleInterceptorStack;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import java.lang.reflect.Method;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class InterceptorExecutor {
    private final StepInvoker stepInvoker;
    private final InterceptorMethodParametersResolver parametersResolver;
    private final Instance<SimpleInterceptorStack> simpleInterceptorStack;

    protected InterceptorExecutor() {
        this(null, null, null);
    }

    @Inject
    public InterceptorExecutor(StepInvoker stepInvoker, InterceptorMethodParametersResolver parametersResolver, Instance<SimpleInterceptorStack> simpleInterceptorStack) {
        this.stepInvoker = stepInvoker;
        this.parametersResolver = parametersResolver;
        this.simpleInterceptorStack = simpleInterceptorStack;
    }

    public void execute(Object interceptor, Method method) {
        if (method != null) {
            this.stepInvoker.tryToInvoke(interceptor, method, new Object[0]);
        }
    }

    public void executeAround(Object interceptor, Method method) {
        if (method != null) {
            Object[] params = this.parametersResolver.parametersFor(method);
            this.stepInvoker.tryToInvoke(interceptor, method, params);
        } else {
            ((SimpleInterceptorStack)this.simpleInterceptorStack.get()).next();
        }
    }
}

