/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.AfterCall;
import br.com.caelum.vraptor.AroundCall;
import br.com.caelum.vraptor.BeforeCall;
import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.interceptor.StepInvoker;
import br.com.caelum.vraptor.interceptor.ValidationRule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class NoInterceptMethodsValidationRule
implements ValidationRule {
    private final StepInvoker stepInvoker;

    protected NoInterceptMethodsValidationRule() {
        this(null);
    }

    @Inject
    public NoInterceptMethodsValidationRule(StepInvoker stepInvoker) {
        this.stepInvoker = stepInvoker;
    }

    @Override
    public void validate(Class<?> originalType, List<Method> methods) {
        boolean hasAfterMethod = this.hasAnnotatedMethod(AfterCall.class, originalType, methods);
        boolean hasAroundMethod = this.hasAnnotatedMethod(AroundCall.class, originalType, methods);
        boolean hasBeforeMethod = this.hasAnnotatedMethod(BeforeCall.class, originalType, methods);
        if (!(hasAfterMethod || hasAroundMethod || hasBeforeMethod)) {
            throw new InterceptionException(String.format("Interceptor %s must declare at least one method whith @AfterCall, @AroundCall or @BeforeCall annotation", originalType.getCanonicalName()));
        }
    }

    private boolean hasAnnotatedMethod(Class<? extends Annotation> step, Class<?> originalType, List<Method> methods) {
        return this.stepInvoker.findMethod(methods, step, originalType) != null;
    }
}

