/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.interceptor.ApplicationLogicException;
import br.com.caelum.vraptor.interceptor.VoidReturn;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class StepInvoker {
    private final ReflectionProvider reflectionProvider;

    protected StepInvoker() {
        this(null);
    }

    @Inject
    public StepInvoker(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }

    public Object tryToInvoke(Object interceptor, Method stepMethod, Object ... params) {
        if (stepMethod == null) {
            return null;
        }
        Object returnObject = this.invokeMethod(interceptor, stepMethod, params);
        if (stepMethod.getReturnType().equals(Void.TYPE)) {
            return new VoidReturn();
        }
        return returnObject;
    }

    private Object invokeMethod(Object interceptor, Method stepMethod, Object ... params) {
        try {
            return this.reflectionProvider.invoke(interceptor, stepMethod, params);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ApplicationLogicException.class);
            throw new InterceptionException(e.getCause());
        }
    }

    public List<Method> findAllMethods(Class<?> interceptorClass) {
        return this.reflectionProvider.getMethodsFor(interceptorClass);
    }

    public Method findMethod(List<Method> interceptorMethods, Class<? extends Annotation> step, Class<?> interceptorClass) {
        FluentIterable possibleMethods = FluentIterable.from(interceptorMethods).filter(this.hasStepAnnotation(step));
        if (possibleMethods.size() > 1 && possibleMethods.allMatch(Predicates.not(this.notSameClass(interceptorClass)))) {
            throw new IllegalStateException(String.format("%s - You should not have more than one @%s annotated method", interceptorClass.getCanonicalName(), step.getSimpleName()));
        }
        return (Method)possibleMethods.first().orNull();
    }

    private Predicate<Method> notSameClass(final Class<?> interceptorClass) {
        return new Predicate<Method>(){

            public boolean apply(Method possibleMethod) {
                return !possibleMethod.getDeclaringClass().equals(interceptorClass);
            }
        };
    }

    private Predicate<Method> hasStepAnnotation(final Class<? extends Annotation> step) {
        return new Predicate<Method>(){

            public boolean apply(Method element) {
                if (element.getDeclaringClass().getSimpleName().contains("$")) {
                    return false;
                }
                return element.isAnnotationPresent(step);
            }
        };
    }
}

