/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.interceptor.AcceptsValidator;
import br.com.caelum.vraptor.interceptor.AcceptsWithAnnotations;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;

@Dependent
public class WithAnnotationAcceptor
implements AcceptsValidator<AcceptsWithAnnotations> {
    private List<Class<? extends Annotation>> allowedTypes;

    @Override
    public boolean validate(ControllerMethod controllerMethod, ControllerInstance instance) {
        return this.containsAllowedTypes(instance.getBeanClass().getAnnotations()) || this.containsAllowedTypes(controllerMethod.getAnnotations());
    }

    private boolean containsAllowedTypes(Annotation[] annotations) {
        return FluentIterable.from(Arrays.asList(annotations)).anyMatch(this.isAllowedType());
    }

    private Predicate<Annotation> isAllowedType() {
        return new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                return WithAnnotationAcceptor.this.allowedTypes.contains(input.annotationType());
            }
        };
    }

    @Override
    public void initialize(AcceptsWithAnnotations annotation) {
        this.allowedTypes = Arrays.asList(annotation.value());
    }
}

