/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi;

import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.proxy.CDIProxies;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CDIBasedContainer
implements Container {
    private static final Logger logger = LoggerFactory.getLogger(CDIBasedContainer.class);
    private final BeanManager beanManager;

    protected CDIBasedContainer() {
        this(null);
    }

    @Inject
    public CDIBasedContainer(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public <T> T instanceFor(Class<T> type) {
        type = CDIProxies.extractRawTypeIfPossible(type);
        logger.debug("asking cdi to get instance for {}", type);
        Bean<?> bean = this.getBeanFrom(type);
        CreationalContext ctx = this.beanManager.createCreationalContext(bean);
        return (T)this.beanManager.getReference(bean, type, ctx);
    }

    @Override
    public <T> boolean canProvide(Class<T> type) {
        type = CDIProxies.extractRawTypeIfPossible(type);
        logger.debug("asking cdi to get instance for {}", type);
        return this.getBeanFrom(type) != null;
    }

    private <T> Bean<?> getBeanFrom(Class<T> type) {
        Set beans = this.beanManager.getBeans(type, new Annotation[0]);
        logger.debug("beans for {} is {}", type, (Object)beans);
        return this.beanManager.resolve(beans);
    }
}

