/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.Consumes;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.events.InterceptorsReady;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.serialization.Deserializer;
import br.com.caelum.vraptor.serialization.Deserializers;
import br.com.caelum.vraptor.view.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DeserializingObserver {
    private final Deserializers deserializers;
    private final Container container;
    private static final Logger logger = LoggerFactory.getLogger(DeserializingObserver.class);

    protected DeserializingObserver() {
        this(null, null);
    }

    @Inject
    public DeserializingObserver(Deserializers deserializers, Container container) {
        this.deserializers = deserializers;
        this.container = container;
    }

    public void deserializes(@Observes InterceptorsReady event, HttpServletRequest request, MethodInfo methodInfo, Status status) throws IOException {
        ControllerMethod method = event.getControllerMethod();
        if (!method.containsAnnotation(Consumes.class)) {
            return;
        }
        List<String> supported = Arrays.asList(method.getMethod().getAnnotation(Consumes.class).value());
        if (request.getContentType() == null) {
            logger.warn("Request does not have Content-Type and parameters will be not deserialized");
            return;
        }
        String contentType = DeserializingObserver.mime(request.getContentType());
        if (!supported.isEmpty() && !supported.contains(contentType)) {
            this.unsupported("Request with media type [%s]. Expecting one of %s.", status, contentType, supported);
            return;
        }
        Deserializer deserializer = this.deserializers.deserializerFor(contentType, this.container);
        if (deserializer == null) {
            this.unsupported("Unable to handle media type [%s]: no deserializer found.", status, contentType);
            return;
        }
        Object[] deserialized = deserializer.deserialize((InputStream)request.getInputStream(), method);
        logger.debug("Deserialized parameters for {} are {} ", (Object)method, (Object)deserialized);
        for (int i = 0; i < deserialized.length; ++i) {
            if (deserialized[i] == null) continue;
            methodInfo.setParameter(i, deserialized[i]);
        }
    }

    private static String mime(String contentType) {
        if (contentType.contains(";")) {
            return contentType.split(";")[0];
        }
        return contentType;
    }

    private void unsupported(String message, Status status, Object ... params) {
        status.unsupportedMediaType(String.format(message, params));
    }
}

