/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.core.Try;
import br.com.caelum.vraptor.events.InterceptorsExecuted;
import br.com.caelum.vraptor.events.MethodExecuted;
import br.com.caelum.vraptor.events.MethodReady;
import br.com.caelum.vraptor.observer.ExecuteMethodExceptionHandler;
import br.com.caelum.vraptor.validator.Messages;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ExecuteMethod {
    private static final Logger log = LoggerFactory.getLogger(ExecuteMethod.class);
    private final MethodInfo methodInfo;
    private final Messages messages;
    private final ReflectionProvider reflectionProvider;
    private final Event<MethodExecuted> methodExecutedEvent;
    private final Event<MethodReady> methodReady;
    private final ExecuteMethodExceptionHandler executeMethodExceptionHandler;

    @Inject
    public ExecuteMethod(MethodInfo methodInfo, Messages messages, Event<MethodExecuted> methodExecutedEvent, Event<MethodReady> methodReady, ExecuteMethodExceptionHandler exceptionHandler, ReflectionProvider reflectionProvider) {
        this.methodInfo = methodInfo;
        this.messages = messages;
        this.methodExecutedEvent = methodExecutedEvent;
        this.methodReady = methodReady;
        this.executeMethodExceptionHandler = exceptionHandler;
        this.reflectionProvider = reflectionProvider;
    }

    public void execute(final @Observes InterceptorsExecuted event) {
        Try run = Try.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ControllerMethod method = event.getControllerMethod();
                ExecuteMethod.this.methodReady.fire((Object)new MethodReady(method));
                Method reflectionMethod = method.getMethod();
                Object[] parameters = ExecuteMethod.this.methodInfo.getParametersValues();
                log.debug("Invoking {}", (Object)reflectionMethod);
                Object instance = event.getControllerInstance();
                Object result = ExecuteMethod.this.reflectionProvider.invoke(instance, reflectionMethod, parameters);
                ExecuteMethod.this.messages.assertAbsenceOfErrors();
                ExecuteMethod.this.methodInfo.setResult(result);
                ExecuteMethod.this.methodExecutedEvent.fire((Object)new MethodExecuted(method, ExecuteMethod.this.methodInfo));
                return null;
            }
        });
        if (run.failed()) {
            Exception exception = run.getException();
            this.executeMethodExceptionHandler.handle(exception);
        }
    }
}

