/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.core.ReflectionProviderException;
import br.com.caelum.vraptor.interceptor.ApplicationLogicException;
import br.com.caelum.vraptor.validator.ValidationException;
import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteMethodExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExecuteMethodExceptionHandler.class);

    public void handle(Exception exception) {
        if (exception instanceof ReflectionProviderException) {
            this.throwIfNotValidationException(exception, exception.getCause());
        }
        this.throwIfNotValidationException(exception, exception);
    }

    private void throwIfNotValidationException(Throwable original, Throwable alternativeCause) {
        Throwable cause = original.getCause();
        if (!(original instanceof ValidationException) && !(cause instanceof ValidationException)) {
            Throwables.propagateIfPossible((Throwable)alternativeCause);
            throw new ApplicationLogicException(alternativeCause);
        }
        log.trace("swallowing {}", cause);
    }
}

