/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.DefaultControllerInstance;
import br.com.caelum.vraptor.events.ControllerFound;
import br.com.caelum.vraptor.ioc.Container;
import com.google.common.base.Preconditions;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@RequestScoped
public class InstantiateObserver {
    private final Container container;
    private ControllerInstance controllerInstance;

    @Inject
    public InstantiateObserver(Container container) {
        this.container = container;
    }

    protected InstantiateObserver() {
        this(null);
    }

    public void instantiate(@Observes ControllerFound event) {
        Object instance = this.container.instanceFor(event.getController().getType());
        this.controllerInstance = new DefaultControllerInstance(instance);
    }

    @Produces
    @Dependent
    public ControllerInstance getControllerInstance() {
        Preconditions.checkState((this.controllerInstance != null ? 1 : 0) != 0, (Object)"ControllerInstance is not initialised yet");
        return this.controllerInstance;
    }
}

