/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.events.MethodExecuted;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class OutjectResult {
    private static final Logger logger = LoggerFactory.getLogger(OutjectResult.class);
    private final TypeNameExtractor extractor;

    protected OutjectResult() {
        this(null);
    }

    @Inject
    public OutjectResult(TypeNameExtractor extractor) {
        this.extractor = extractor;
    }

    public void outject(@Observes MethodExecuted event, Result result, MethodInfo methodInfo) {
        Type returnType = event.getMethodReturnType();
        if (!returnType.equals(Void.TYPE)) {
            String name = this.extractor.nameFor(returnType);
            Object value = methodInfo.getResult();
            logger.debug("outjecting {}={}", (Object)name, value);
            result.include(name, value);
        }
    }
}

