/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.download;

import br.com.caelum.vraptor.observer.download.Download;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ZipDownload
implements Download {
    private final String filename;
    private final Iterable<Path> files;

    public ZipDownload(String filename, Iterable<Path> files) {
        this.filename = filename;
        this.files = files;
    }

    public ZipDownload(String filename, Path ... files) {
        this(filename, Arrays.asList(files));
    }

    @Override
    public void write(HttpServletResponse response) throws IOException {
        response.setHeader("Content-disposition", "attachment; filename=" + this.filename);
        response.setHeader("Content-type", "application/zip");
        CheckedOutputStream stream = new CheckedOutputStream((OutputStream)response.getOutputStream(), new CRC32());
        try (ZipOutputStream zip = new ZipOutputStream(stream);){
            for (Path file : this.files) {
                zip.putNextEntry(new ZipEntry(file.getFileName().toString()));
                Files.copy(file, zip);
                zip.closeEntry();
            }
        }
    }
}

