/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.upload;

import br.com.caelum.vraptor.observer.upload.UploadedFile;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.enterprise.inject.Vetoed;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Vetoed
public class CommonsUploadedFile
implements UploadedFile {
    private static final String TARGET_CANNOT_BE_NULL = "Target can't be null";
    private final FileItem delegate;

    public CommonsUploadedFile(FileItem fileItem) {
        this.delegate = fileItem;
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public InputStream getFile() throws IOException {
        return this.delegate.getInputStream();
    }

    @Override
    public String getFileName() {
        return FilenameUtils.getName((String)this.delegate.getName());
    }

    @Override
    public long getSize() {
        return this.delegate.getSize();
    }

    @Override
    public void writeTo(File target) throws IOException {
        Objects.requireNonNull(target, TARGET_CANNOT_BE_NULL);
        try {
            this.delegate.write(target);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void writeTo(Path target, CopyOption ... options) throws IOException {
        Objects.requireNonNull(target, TARGET_CANNOT_BE_NULL);
        this.writeTo(target.toFile());
    }

    @Override
    public void writeTo(OutputStream target) throws IOException {
        Objects.requireNonNull(target, TARGET_CANNOT_BE_NULL);
        IOUtils.copy((InputStream)this.getFile(), (OutputStream)target);
    }

    public String toString() {
        return String.format("UploadedFile[name=%s]", this.getFileName());
    }
}

