/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.upload;

import br.com.caelum.vraptor.observer.upload.MultipartConfig;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultMultipartConfig
implements MultipartConfig {
    private final Logger logger = LoggerFactory.getLogger(DefaultMultipartConfig.class);
    private Path tmpdir;

    @Override
    public long getSizeLimit() {
        return 0x200000L;
    }

    @Override
    public long getFileSizeLimit() {
        return 0x200000L;
    }

    @Override
    public File getDirectory() {
        if (this.tmpdir == null) {
            this.tmpdir = this.getTemporaryDirectory();
        }
        if (this.tmpdir == null) {
            this.tmpdir = this.createDirInsideApplication();
        }
        return this.tmpdir.toFile();
    }

    protected Path getTemporaryDirectory() {
        return AccessController.doPrivileged(new PrivilegedAction<Path>(){

            @Override
            public Path run() {
                try {
                    Path tmp = Files.createTempFile("vraptor", "upload", new FileAttribute[0]);
                    Path parent = tmp.getParent();
                    DefaultMultipartConfig.this.logger.debug("Using temporary directory as {}", (Object)parent);
                    Files.delete(tmp);
                    return parent;
                }
                catch (IOException e) {
                    DefaultMultipartConfig.this.logger.warn("Unable to find temp directory", (Throwable)e);
                    return null;
                }
            }
        });
    }

    protected Path createDirInsideApplication() {
        this.logger.debug("Creating a dir inside the application");
        return AccessController.doPrivileged(new PrivilegedAction<Path>(){

            @Override
            public Path run() {
                try {
                    Path path = Paths.get(".tmp-multipart-upload", new String[0]);
                    DefaultMultipartConfig.this.logger.debug("Using temporary directory as {}", (Object)path);
                    return Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    DefaultMultipartConfig.this.logger.error("Unable to use temp directory inside application", (Throwable)e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }
}

