/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.observer.upload;

import br.com.caelum.vraptor.observer.upload.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import javax.enterprise.inject.Vetoed;
import org.apache.commons.io.IOUtils;

@Vetoed
public class DefaultUploadedFile
implements UploadedFile {
    private static final String TARGET_CANNOT_BE_NULL = "Target can't be null";
    private final String contentType;
    private final String fileName;
    private final InputStream content;
    private final long size;

    public DefaultUploadedFile(InputStream content, String fileName, String contentType, long size) {
        this.content = content;
        this.fileName = fileName;
        this.contentType = contentType;
        this.size = size;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getFile() throws IOException {
        return this.content;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void writeTo(File target) throws IOException {
        Objects.requireNonNull(target, TARGET_CANNOT_BE_NULL);
        this.writeTo(target.toPath(), new CopyOption[0]);
    }

    @Override
    public void writeTo(Path target, CopyOption ... options) throws IOException {
        Objects.requireNonNull(target, TARGET_CANNOT_BE_NULL);
        try (InputStream in = this.getFile();){
            Files.copy(in, target, options);
        }
    }

    @Override
    public void writeTo(OutputStream target) throws IOException {
        Objects.requireNonNull(target, TARGET_CANNOT_BE_NULL);
        IOUtils.copy((InputStream)this.getFile(), (OutputStream)target);
    }

    public String toString() {
        return String.format("UploadedFile[name=%s]", this.getFileName());
    }
}

