/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.proxy;

import br.com.caelum.vraptor.proxy.CDIProxies;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyCreationException;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JavassistProxifier
implements Proxifier {
    private static final Logger logger = LoggerFactory.getLogger(JavassistProxifier.class);
    private static final MethodFilter IGNORE_BRIDGE_AND_OBJECT_METHODS = new MethodFilter(){

        public boolean isHandled(Method method) {
            return !method.isBridge() && !method.getDeclaringClass().equals(Object.class);
        }
    };

    @Override
    public <T> T proxify(Class<T> type, MethodInvocation<? super T> handler) {
        ProxyFactory factory = new ProxyFactory();
        factory.setFilter(IGNORE_BRIDGE_AND_OBJECT_METHODS);
        Class<?> rawType = this.extractRawType(type);
        if (type.isInterface()) {
            factory.setInterfaces(new Class[]{rawType});
        } else {
            factory.setSuperclass(rawType);
        }
        Object instance = this.createInstance(type, handler, factory);
        logger.debug("a proxy for {} was created as {}", type, instance.getClass());
        return (T)instance;
    }

    private <T> Object createInstance(Class<T> type, MethodInvocation<? super T> handler, ProxyFactory factory) {
        try {
            return factory.create(null, null, new MethodInvocationAdapter<T>(handler));
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            logger.error("An error occurs when create a proxy for type " + type, (Throwable)e);
            throw new ProxyCreationException(e);
        }
    }

    private <T> Class<?> extractRawType(Class<T> type) {
        return this.isProxyType(type) ? type.getSuperclass() : type;
    }

    @Override
    public boolean isProxy(Object o) {
        return o != null && this.isProxyType(o.getClass());
    }

    @Override
    public boolean isProxyType(Class<?> type) {
        boolean proxy = ProxyFactory.isProxyClass(type) || CDIProxies.isCDIProxy(type);
        logger.debug("Class {} is proxy: {}", (Object)type.getName(), (Object)proxy);
        return proxy;
    }

    private static class MethodInvocationAdapter<T>
    implements MethodHandler {
        private final MethodInvocation<? super T> handler;

        public MethodInvocationAdapter(MethodInvocation<? super T> handler) {
            this.handler = handler;
        }

        public Object invoke(Object self, Method thisMethod, final Method proceed, Object[] args) throws Throwable {
            return this.handler.intercept(self, thisMethod, args, new SuperMethod(){

                @Override
                public Object invoke(Object proxy, Object[] args) {
                    try {
                        return proceed.invoke(proxy, args);
                    }
                    catch (Throwable throwable) {
                        throw new ProxyInvocationException(throwable);
                    }
                }
            });
        }
    }
}

