/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.serialization.Deserializer;
import br.com.caelum.vraptor.serialization.Deserializers;
import br.com.caelum.vraptor.serialization.Deserializes;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class DefaultDeserializers
implements Deserializers {
    private final Map<String, Class<? extends Deserializer>> deserializers = new HashMap<String, Class<? extends Deserializer>>();

    @Override
    public Deserializer deserializerFor(String contentType, Container container) {
        if (this.deserializers.containsKey(contentType)) {
            return container.instanceFor(this.deserializers.get(contentType));
        }
        return this.subpathDeserializerFor(contentType, container);
    }

    private Deserializer subpathDeserializerFor(String contentType, Container container) {
        String newType;
        if (contentType.contains("/") && this.deserializers.containsKey(newType = DefaultDeserializers.removeChar(contentType, "/"))) {
            return container.instanceFor(this.deserializers.get(newType));
        }
        return this.subpathDeserializerForPlus(contentType, container);
    }

    private Deserializer subpathDeserializerForPlus(String contentType, Container container) {
        String newType;
        if (contentType.contains("+") && this.deserializers.containsKey(newType = DefaultDeserializers.removeChar(contentType, "+"))) {
            return container.instanceFor(this.deserializers.get(newType));
        }
        return null;
    }

    private static String removeChar(String type, String by) {
        return type.substring(type.lastIndexOf(by) + 1);
    }

    @Override
    public void register(Class<? extends Deserializer> type) {
        Deserializes deserializes = type.getAnnotation(Deserializes.class);
        Preconditions.checkArgument((deserializes != null ? 1 : 0) != 0, (Object)"You must annotate your deserializers with @Deserializes");
        for (String contentType : deserializes.value()) {
            this.deserializers.put(contentType, type);
        }
    }
}

