/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.serialization.IgnoringSerializer;
import br.com.caelum.vraptor.serialization.RepresentationResult;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.view.Results;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@RequestScoped
public class DefaultRepresentationResult
implements RepresentationResult {
    private final FormatResolver formatResolver;
    private final Iterable<Serialization> serializations;
    private final Result result;

    protected DefaultRepresentationResult() {
        this(null, null, null);
    }

    @Inject
    public DefaultRepresentationResult(FormatResolver formatResolver, Result result, @Any Instance<Serialization> serializations) {
        this.formatResolver = formatResolver;
        this.result = result;
        this.serializations = serializations;
    }

    @Override
    public <T> Serializer from(T object) {
        return this.from(object, null);
    }

    protected void sortSerializations(List<Serialization> serializations) {
        Collections.sort(serializations, new ApplicationPackageFirst());
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        if (object == null) {
            this.result.use(Results.status()).notFound();
            return new IgnoringSerializer();
        }
        ArrayList serializations = Lists.newArrayList(this.serializations);
        this.sortSerializations(serializations);
        String format = this.formatResolver.getAcceptFormat();
        for (Serialization serialization : serializations) {
            if (!serialization.accepts(format)) continue;
            if (alias == null) {
                return serialization.from(object);
            }
            return serialization.from(object, alias);
        }
        this.result.use(Results.status()).notAcceptable();
        return new IgnoringSerializer();
    }

    static final class ApplicationPackageFirst
    implements Comparator<Serialization>,
    Serializable {
        public static final long serialVersionUID = 1L;
        private static final String VRAPTOR_PACKAGE = "br.com.caelum.vraptor.serialization";

        ApplicationPackageFirst() {
        }

        private int priority(Serialization s) {
            return s.getClass().getPackage().getName().startsWith(VRAPTOR_PACKAGE) ? 1 : 0;
        }

        @Override
        public int compare(Serialization o1, Serialization o2) {
            return this.priority(o1) - this.priority(o2);
        }
    }
}

