/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.IgnoringSerializer;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.view.Results;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;

@RequestScoped
public class HTMLSerialization
implements Serialization {
    private final Result result;
    private final TypeNameExtractor extractor;

    protected HTMLSerialization() {
        this(null, null);
    }

    @Inject
    public HTMLSerialization(Result result, TypeNameExtractor extractor) {
        this.result = result;
        this.extractor = extractor;
    }

    @Override
    public boolean accepts(String format) {
        return "html".equals(format);
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.result.include(alias, object);
        this.result.use(Results.page()).defaultView();
        return new IgnoringSerializer();
    }

    @Override
    public <T> Serializer from(T object) {
        this.result.include(this.extractor.nameFor(object.getClass()), object);
        this.result.use(Results.page()).defaultView();
        return new IgnoringSerializer();
    }
}

