/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.JSONPSerialization;
import br.com.caelum.vraptor.serialization.JSONSerialization;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.gson.GsonJSONSerialization;
import br.com.caelum.vraptor.serialization.gson.GsonSerializer;
import br.com.caelum.vraptor.serialization.gson.GsonSerializerBuilder;
import br.com.caelum.vraptor.view.ResultException;
import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;

@RequestScoped
public class GsonJSONPSerialization
implements JSONPSerialization {
    private final HttpServletResponse response;
    private final TypeNameExtractor extractor;
    private final GsonSerializerBuilder builder;
    private final Environment environment;
    private final ReflectionProvider reflectionProvider;

    protected GsonJSONPSerialization() {
        this(null, null, null, null, null);
    }

    @Inject
    public GsonJSONPSerialization(HttpServletResponse response, TypeNameExtractor extractor, GsonSerializerBuilder builder, Environment environment, ReflectionProvider reflectionProvider) {
        this.response = response;
        this.extractor = extractor;
        this.builder = builder;
        this.environment = environment;
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public JSONSerialization withCallback(final String callbackName) {
        return new GsonJSONSerialization(this.response, this.extractor, this.builder, this.environment, this.reflectionProvider){

            @Override
            protected SerializerBuilder getSerializer() {
                try {
                    return new GsonSerializer(GsonJSONPSerialization.this.builder, GsonJSONPSerialization.this.response.getWriter(), GsonJSONPSerialization.this.extractor, GsonJSONPSerialization.this.reflectionProvider){

                        @Override
                        public void serialize() {
                            try {
                                GsonJSONPSerialization.this.response.getWriter().append(callbackName).append("(");
                                super.serialize();
                                GsonJSONPSerialization.this.response.getWriter().append(")");
                            }
                            catch (IOException e) {
                                throw new ResultException("Unable to serialize data", e);
                            }
                        }
                    };
                }
                catch (IOException e) {
                    throw new ResultException("Unable to serialize data", e);
                }
            }
        };
    }
}

