/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.JSONSerialization;
import br.com.caelum.vraptor.serialization.NoRootSerialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.gson.GsonSerializer;
import br.com.caelum.vraptor.serialization.gson.GsonSerializerBuilder;
import br.com.caelum.vraptor.view.ResultException;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;

@RequestScoped
public class GsonJSONSerialization
implements JSONSerialization {
    private final HttpServletResponse response;
    private final TypeNameExtractor extractor;
    private final GsonSerializerBuilder builder;
    private Environment environment;
    private ReflectionProvider reflectionProvider;

    protected GsonJSONSerialization() {
        this(null, null, null, null, null);
    }

    @Inject
    public GsonJSONSerialization(HttpServletResponse response, TypeNameExtractor extractor, GsonSerializerBuilder builder, Environment environment, ReflectionProvider reflectionProvider) {
        this.response = response;
        this.extractor = extractor;
        this.builder = builder;
        this.environment = environment;
        this.reflectionProvider = reflectionProvider;
    }

    @PostConstruct
    protected void init() {
        if (this.environment.supports("br.com.caelum.vraptor.serialization.json.indented")) {
            this.builder.indented();
        }
    }

    @Override
    public boolean accepts(String format) {
        return "json".equals(format);
    }

    @Override
    public <T> Serializer from(T object) {
        return this.from(object, null);
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.response.setContentType("application/json");
        return this.getSerializer().from(object, alias);
    }

    protected SerializerBuilder getSerializer() {
        try {
            return new GsonSerializer(this.builder, this.response.getWriter(), this.extractor, this.reflectionProvider);
        }
        catch (IOException e) {
            throw new ResultException("Unable to serialize data", e);
        }
    }

    @Override
    public NoRootSerialization withoutRoot() {
        this.builder.setWithoutRoot(true);
        return this;
    }

    @Override
    public JSONSerialization indented() {
        this.builder.indented();
        return this;
    }

    @Override
    public JSONSerialization version(double versionNumber) {
        this.builder.version(versionNumber);
        return this;
    }

    @Override
    public JSONSerialization serializeNulls() {
        this.builder.serializeNulls();
        return this;
    }
}

