/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.Serializee;
import br.com.caelum.vraptor.validator.Message;
import com.google.common.base.Supplier;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class VRaptorClassMapper
extends MapperWrapper {
    private final Supplier<TypeNameExtractor> extractor;
    private final Supplier<Serializee> serializee;
    private final Supplier<ReflectionProvider> reflectionProvider;

    public VRaptorClassMapper(Mapper wrapped, Supplier<TypeNameExtractor> supplier, Supplier<Serializee> serializee, Supplier<ReflectionProvider> reflectionProvider) {
        super(wrapped);
        this.extractor = supplier;
        this.serializee = serializee;
        this.reflectionProvider = reflectionProvider;
    }

    static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type.isEnum() || Number.class.isAssignableFrom(type) || type.equals(String.class) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        for (Map.Entry include : this.getSerializee().getIncludes().entries()) {
            if (!VRaptorClassMapper.isCompatiblePath(include, definedIn, fieldName)) continue;
            return true;
        }
        for (Map.Entry exclude : this.getSerializee().getExcludes().entries()) {
            if (!VRaptorClassMapper.isCompatiblePath(exclude, definedIn, fieldName)) continue;
            return false;
        }
        boolean should = super.shouldSerializeMember(definedIn, fieldName);
        if (!this.getSerializee().isRecursive()) {
            should = should && VRaptorClassMapper.isPrimitive(((ReflectionProvider)this.reflectionProvider.get()).getField(definedIn, fieldName).getType());
        }
        return should;
    }

    private static boolean isCompatiblePath(Map.Entry<String, Class<?>> path, Class definedIn, String fieldName) {
        return path.getValue().equals(definedIn) && (path.getKey().equals(fieldName) || path.getKey().endsWith("." + fieldName));
    }

    public String serializedClass(Class type) {
        if (type == null) {
            return super.serializedClass(type);
        }
        if (Message.class.isAssignableFrom(type)) {
            return "message";
        }
        String superName = super.serializedClass(type);
        if (type.getName().equals(superName)) {
            return ((TypeNameExtractor)this.extractor.get()).nameFor(type);
        }
        return superName;
    }

    public Serializee getSerializee() {
        return (Serializee)this.serializee.get();
    }
}

