/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.XMLSerialization;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamSerializer;
import br.com.caelum.vraptor.view.ResultException;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;

@RequestScoped
public class XStreamXMLSerialization
implements XMLSerialization {
    private final HttpServletResponse response;
    private final XStreamBuilder builder;
    private final Environment environment;
    private boolean indented;

    protected XStreamXMLSerialization() {
        this(null, null, null);
    }

    @Inject
    public XStreamXMLSerialization(HttpServletResponse response, XStreamBuilder builder, Environment environment) {
        this.response = response;
        this.builder = builder;
        this.environment = environment;
    }

    @PostConstruct
    protected void init() {
        this.indented = this.environment.supports("br.com.caelum.vraptor.serialization.xml.indented");
    }

    @Override
    public boolean accepts(String format) {
        return "xml".equals(format);
    }

    @Override
    public XMLSerialization indented() {
        this.indented = true;
        return this;
    }

    @Override
    public <T> Serializer from(T object) {
        this.response.setContentType("application/xml");
        return this.getSerializer().from(object);
    }

    protected SerializerBuilder getSerializer() {
        return new XStreamSerializer(this.builder.xmlInstance(), this.getWriter());
    }

    protected HierarchicalStreamWriter getWriter() {
        try {
            PrintWriter writer = this.response.getWriter();
            return this.indented ? new PrettyPrintWriter((Writer)writer) : new CompactWriter((Writer)writer);
        }
        catch (IOException e) {
            throw new ResultException("Unable to serialize data", e);
        }
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.response.setContentType("application/xml");
        return this.getSerializer().from(object, alias);
    }
}

