/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.enterprise.inject.Vetoed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class SafeResourceBundle
extends ResourceBundle {
    private static final Logger logger = LoggerFactory.getLogger(SafeResourceBundle.class);
    private final ResourceBundle delegate;
    private final boolean isDefault;

    public SafeResourceBundle(ResourceBundle delegate) {
        this(delegate, false);
    }

    public SafeResourceBundle(ResourceBundle delegate, boolean isDefault) {
        Objects.requireNonNull(delegate, "Bundle should not be null. Please report it to VRaptor devs.");
        this.delegate = delegate;
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.delegate.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        try {
            return this.delegate.getString(key);
        }
        catch (MissingResourceException e) {
            logger.warn("Resource missed while calling delegate", (Throwable)e);
            return "???" + key + "???";
        }
    }
}

