/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.validator.I18nParam;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.Severity;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class I18nMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private final Object category;
    private final String message;
    private final Object[] parameters;
    private transient ResourceBundle bundle;
    private final Severity severity;

    public I18nMessage(I18nParam category, String message, Object ... parameters) {
        this.category = category;
        this.message = message;
        this.parameters = parameters;
        this.severity = Severity.ERROR;
    }

    public I18nMessage(String category, String message, Object ... parameters) {
        this(category, message, Severity.ERROR, parameters);
    }

    public I18nMessage(String category, String message, Severity severity, Object ... parameters) {
        this.category = category;
        this.message = message;
        this.parameters = parameters;
        this.severity = severity;
    }

    @Override
    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public String getMessage() {
        this.checkBundle();
        return MessageFormat.format(this.bundle.getString(this.message), this.i18n(this.parameters));
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    private void checkBundle() {
        if (this.bundle == null) {
            throw new IllegalStateException("You must set the bundle before using the I18nMessage");
        }
    }

    private Object[] i18n(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof I18nParam)) continue;
            parameters[i] = ((I18nParam)parameters[i]).getKey(this.bundle);
        }
        return parameters;
    }

    @Override
    public String getCategory() {
        if (this.category instanceof I18nParam) {
            this.checkBundle();
            return ((I18nParam)this.category).getKey(this.bundle);
        }
        return this.category.toString();
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("category", this.category).add("message", (Object)this.message).add("severity", (Object)this.severity).add("parameters", (Object)this.parameters).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.category) ^ Objects.hashCode(this.message) ^ Objects.hash(this.parameters) ^ Objects.hashCode((Object)this.severity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        I18nMessage other = (I18nMessage)obj;
        return Objects.equals(this.category, other.category) && Objects.equals(this.message, other.message) && (this.parameters == null && other.parameters == null || Arrays.equals(this.parameters, other.parameters)) && Objects.equals((Object)this.severity, (Object)other.severity);
    }
}

