/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.Severity;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class SimpleMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String category;
    private final Severity severity;
    private final Object[] messageParameters;

    public SimpleMessage(String category, String message, Object ... messageParameters) {
        this(category, message, Severity.ERROR, messageParameters);
    }

    public SimpleMessage(String category, String message, Severity severity, Object ... messageParameters) {
        this.category = category;
        this.message = message;
        this.messageParameters = messageParameters;
        this.severity = severity;
    }

    @Override
    public String getMessage() {
        if (this.messageParameters != null && this.messageParameters.length > 0) {
            return MessageFormat.format(this.message, this.messageParameters);
        }
        return this.message;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setBundle(ResourceBundle bundle) {
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("category", (Object)this.category).add("message", (Object)this.message).add("severity", (Object)this.severity).add("parameters", (Object)this.messageParameters).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.category) ^ Objects.hashCode(this.message) ^ Objects.hash(this.messageParameters) ^ Objects.hashCode((Object)this.severity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMessage other = (SimpleMessage)obj;
        return Objects.equals(this.category, other.category) && Objects.equals(this.message, other.message) && (this.messageParameters == null && other.messageParameters == null || Arrays.equals(this.messageParameters, other.messageParameters)) && Objects.equals((Object)this.severity, (Object)other.severity);
    }
}

