/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.Get;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.DefaultControllerMethod;
import br.com.caelum.vraptor.controller.HttpMethod;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.proxy.CDIProxies;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.view.FlashScope;
import br.com.caelum.vraptor.view.LogicResult;
import br.com.caelum.vraptor.view.PathResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultLogicResult
implements LogicResult {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLogicResult.class);
    private final Proxifier proxifier;
    private final Router router;
    private final MutableRequest request;
    private final HttpServletResponse response;
    private final Container container;
    private final PathResolver resolver;
    private final TypeNameExtractor extractor;
    private final FlashScope flash;
    private final MethodInfo methodInfo;

    protected DefaultLogicResult() {
        this(null, null, null, null, null, null, null, null, null);
    }

    @Inject
    public DefaultLogicResult(Proxifier proxifier, Router router, MutableRequest request, HttpServletResponse response, Container container, PathResolver resolver, TypeNameExtractor extractor, FlashScope flash, MethodInfo methodInfo) {
        this.proxifier = proxifier;
        this.response = CDIProxies.unproxifyIfPossible(response);
        this.request = CDIProxies.unproxifyIfPossible(request);
        this.router = router;
        this.container = container;
        this.resolver = resolver;
        this.extractor = extractor;
        this.flash = flash;
        this.methodInfo = methodInfo;
    }

    @Override
    public <T> T forwardTo(final Class<T> type) {
        return this.proxifier.proxify(type, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                try {
                    logger.debug("Executing {}", (Object)method);
                    ControllerMethod old = DefaultLogicResult.this.methodInfo.getControllerMethod();
                    DefaultLogicResult.this.methodInfo.setControllerMethod(DefaultControllerMethod.instanceFor(type, method));
                    Object methodResult = method.invoke(DefaultLogicResult.this.container.instanceFor(type), args);
                    DefaultLogicResult.this.methodInfo.setControllerMethod(old);
                    Type returnType = method.getGenericReturnType();
                    if (returnType != Void.TYPE) {
                        DefaultLogicResult.this.request.setAttribute(DefaultLogicResult.this.extractor.nameFor(returnType), methodResult);
                    }
                    if (DefaultLogicResult.this.response.isCommitted()) {
                        logger.debug("Response already commited, not forwarding.");
                        return null;
                    }
                    String path = DefaultLogicResult.this.resolver.pathFor(DefaultControllerMethod.instanceFor(type, method));
                    logger.debug("Forwarding to {}", (Object)path);
                    DefaultLogicResult.this.request.getRequestDispatcher(path).forward((ServletRequest)DefaultLogicResult.this.request, (ServletResponse)DefaultLogicResult.this.response);
                    return null;
                }
                catch (InvocationTargetException e) {
                    Throwables.propagateIfPossible((Throwable)e.getCause());
                    throw new ProxyInvocationException(e);
                }
                catch (Exception e) {
                    throw new ProxyInvocationException(e);
                }
            }
        });
    }

    @Override
    public <T> T redirectTo(final Class<T> type) {
        logger.debug("redirecting to class {}", (Object)type.getSimpleName());
        return this.proxifier.proxify(type, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                Preconditions.checkArgument((boolean)DefaultLogicResult.this.acceptsHttpGet(method), (Object)"Your logic method must accept HTTP GET method if you want to redirect to it");
                try {
                    String url = DefaultLogicResult.this.router.urlFor(type, method, args);
                    String path = DefaultLogicResult.this.request.getContextPath() + url;
                    DefaultLogicResult.this.includeParametersInFlash(type, method, args);
                    logger.debug("redirecting to {}", (Object)path);
                    DefaultLogicResult.this.response.sendRedirect(path);
                    return null;
                }
                catch (IOException e) {
                    throw new ProxyInvocationException(e);
                }
            }
        });
    }

    protected <T> void includeParametersInFlash(Class<T> type, Method method, Object[] args) {
        if (args != null && args.length != 0) {
            this.flash.includeParameters(DefaultControllerMethod.instanceFor(type, method), args);
        }
    }

    protected boolean acceptsHttpGet(Method method) {
        if (method.isAnnotationPresent(Get.class)) {
            return true;
        }
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!method.isAnnotationPresent(httpMethod.getAnnotation())) continue;
            return false;
        }
        return true;
    }
}

