/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.view.PathResolver;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultPathResolver
implements PathResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPathResolver.class);
    private final FormatResolver resolver;

    protected DefaultPathResolver() {
        this(null);
    }

    @Inject
    public DefaultPathResolver(FormatResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public String pathFor(ControllerMethod method) {
        logger.debug("Resolving path for {}", (Object)method);
        String format = this.resolver.getAcceptFormat();
        String suffix = "";
        if (format != null && !format.equals("html")) {
            suffix = "." + format;
        }
        String name = method.getController().getType().getSimpleName();
        String folderName = this.extractControllerFromName(name);
        String path = this.getPrefix() + folderName + "/" + method.getMethod().getName() + suffix + "." + this.getExtension();
        logger.debug("Returning path {} for {}", (Object)path, (Object)method);
        return path;
    }

    protected String getPrefix() {
        return "/WEB-INF/jsp/";
    }

    protected String getExtension() {
        return "jsp";
    }

    protected String extractControllerFromName(String baseName) {
        if ((baseName = DefaultPathResolver.lowerFirstCharacter(baseName)).endsWith("Controller")) {
            return baseName.substring(0, baseName.lastIndexOf("Controller"));
        }
        return baseName;
    }

    private static String lowerFirstCharacter(String baseName) {
        return baseName.toLowerCase().substring(0, 1) + baseName.substring(1, baseName.length());
    }
}

