/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.jbake;

import br.com.ingenieux.mojo.jbake.WatchMojo;
import java.io.File;
import net_alchim31_livereload.LRServer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.platform.Verticle;

@Mojo(name="inline", requiresDirectInvocation=true, requiresProject=false)
public class InlineMojo
extends WatchMojo {
    @Parameter(property="jbake.listenAddress", defaultValue="127.0.0.1")
    private String listenAddress;
    @Parameter(property="jbake.indexFile", defaultValue="index.html")
    private String indexFile;
    @Parameter(property="jbake.port", defaultValue="8080")
    private Integer port;
    @Parameter(property="jbake.livereload", defaultValue="true")
    private Boolean livereload;
    Server server = new Server();
    LRServer lrServer;

    @Override
    protected void stopServer() throws MojoExecutionException {
        if (this.lrServer != null) {
            try {
                this.lrServer.stop();
            }
            catch (Exception e) {
                throw new MojoExecutionException("LiveReload Failure", e);
            }
        }
        this.server.stop();
    }

    @Override
    protected void initServer() throws MojoExecutionException {
        this.server.start();
        if (Boolean.TRUE.equals(this.livereload)) {
            this.lrServer = new LRServer(35729, this.outputDirectory.toPath());
            try {
                this.lrServer.start();
            }
            catch (Exception e) {
                throw new MojoExecutionException("LiveReload Failure", e);
            }
        }
    }

    class Server
    extends Verticle {
        Server() {
            this.vertx = VertxFactory.newVertx();
        }

        public void start() {
            this.vertx.createHttpServer().requestHandler((Handler)new Handler<HttpServerRequest>(){

                public void handle(HttpServerRequest req) {
                    String file;
                    String string = file = req.path().endsWith("/") ? req.path() + InlineMojo.this.indexFile : req.path();
                    if (new File(InlineMojo.this.outputDirectory + file).isDirectory()) {
                        req.response().setStatusCode(301).putHeader("Location", file + "/").close();
                    } else {
                        req.response().sendFile(InlineMojo.this.outputDirectory.getAbsolutePath() + file);
                    }
                }
            }).listen(InlineMojo.this.port.intValue(), InlineMojo.this.listenAddress);
        }
    }
}

