/*
 * Decompiled with CFR 0.152.
 */
package br.com.jansenfelipe.androidmask;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import br.com.jansenfelipe.androidmask.Utils;
import java.util.HashSet;
import java.util.Set;

public class MaskEditTextChangedListener
implements TextWatcher {
    private static MaskEditTextChangedListener instance;
    private String mMask;
    private EditText mEditText;
    private Set<String> symbolMask = new HashSet<String>();
    private boolean isUpdating;
    private String old = "";

    public MaskEditTextChangedListener(String mask, EditText editText) {
        this.mMask = mask;
        this.mEditText = editText;
        this.initSymbolMask();
    }

    private void initSymbolMask() {
        for (int i = 0; i < this.mMask.length(); ++i) {
            char ch = this.mMask.charAt(i);
            if (ch == '#') continue;
            this.symbolMask.add(String.valueOf(ch));
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        String str = Utils.unmask(s.toString(), this.symbolMask);
        String mascara = "";
        if (this.isUpdating) {
            this.old = str;
            this.isUpdating = false;
            return;
        }
        mascara = str.length() > this.old.length() ? Utils.mask(this.mMask, str) : s.toString();
        this.isUpdating = true;
        this.mEditText.setText((CharSequence)mascara);
        this.mEditText.setSelection(mascara.length());
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }
}

