package br.com.jarch.jpa.api;

import br.com.jarch.model.IBaseEntity;

import javax.persistence.metamodel.SingularAttribute;

public final class Aggregate {

    public static <E extends IBaseEntity> IAggregate<E> avg(String field) {
        return () -> "AVG(" + field + ")";
    }

    public static <E extends IBaseEntity> IAggregate<E> avg(SingularAttribute<? extends E, ? extends Number> singularAttribute) {
        return avg(singularAttribute.getName());
    }

    public static <E extends IBaseEntity> IAggregate<E> count(String field) {
        return () -> "COUNT(" + field + ")";
    }

    public static <E extends IBaseEntity> IAggregate<E> count(SingularAttribute<? super E, ?> singularAttribute) {
        return count(singularAttribute.getName());
    }

    public static <E extends IBaseEntity> IAggregate<E>countDistinct(String field) {
        return () -> "COUNT(DISTINCT " + field + ")";
    }

    public static <E extends IBaseEntity> IAggregate<E> countDistinct(SingularAttribute<? super E, ?> singularAttribute) {
        return countDistinct(singularAttribute.getName());
    }

    public static <E extends IBaseEntity> IAggregate<E> min(String field) {
        return () -> "MIN(" + field + ")";
    }

    public static <E extends IBaseEntity> IAggregate<E> min(SingularAttribute<? super E, ? extends Number> singularAttribute) {
        return min(singularAttribute.getName());
    }

    public static <E extends IBaseEntity> IAggregate<E> max(String field) {
        return () -> "MAX(" + field + ")";
    }

    public static <E extends IBaseEntity> IAggregate<E> max(SingularAttribute<? super E, ? extends Number> singularAttribute) {
        return max(singularAttribute.getName());
    }

    public static <E extends IBaseEntity> IAggregate<E> sum(String field) {
        return () -> "SUM(" + field + ")";
    }

    public static <E extends IBaseEntity> IAggregate<E> sum(SingularAttribute<? super E, ? extends Number> singularAttribute) {
        return sum(singularAttribute.getName());
    }
}
