package br.com.jarch.jpa.api;

import br.com.jarch.jpa.param.ParamFieldValue;
import br.com.jarch.jpa.param.ParamFieldValues;
import br.com.jarch.jpa.type.FieldOrder;
import br.com.jarch.jpa.util.EntityManagerFilterUtils;
import br.com.jarch.model.IBaseEntity;
import br.com.jarch.model.MultiTenant;
import br.com.jarch.util.JpaUtils;
import br.com.jarch.util.type.EntityGraphType;

import javax.enterprise.inject.spi.CDI;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import java.util.ArrayList;
import java.util.List;

public class ClientJpaql<E extends IBaseEntity> {

    ParamFieldValues paramFieldValues;

    boolean cacheable;

    boolean distinct;

    int firstResult;

    int maxResults;

    List<String> groupBys;

    List<IAggregate<E>> aggregates;

    List<FieldOrder> orderBys;

    List<JoinFetch> joinFetchs;

    String entityGraph;

    EntityGraphType graphType;

    private EntityManager entityManager;

    private Class<E> classEntity;

    ClientJpaql(Class<E> classEntity) {
        entityManager = CDI.current().select(EntityManager.class).get();
        this.classEntity = classEntity;
        paramFieldValues = new ParamFieldValues(classEntity);
        orderBys = new ArrayList<>();
        groupBys = new ArrayList<>();
        aggregates = new ArrayList<>();
        joinFetchs = new ArrayList<>();
    }

    public ClientJpaql<E> cacheable() {
        cacheable = true;
        return this;
    }

    public ClientJpaql<E> distinct() {
        distinct = true;
        return this;
    }

    public WhereJpaql<E> where() {
        return new WhereJpaql<>(this, ParamFieldValue.OperatorType.AND);
    }

    public CollectorJpaql<E> collect() {
        return new CollectorJpaql<>(this);
    }

    Class<E> getClassEntity() {
        return classEntity;
    }

    EntityManager getEntityManager() {
        EntityManagerFilterUtils.addFilters(entityManager, CDI.current().select(MultiTenant.class).get());
        return entityManager;
    }

    public ClientJpaql<E> setFirstResults(int firstResults) {
        this.firstResult = firstResults;
        return this;
    }

    public ClientJpaql<E> setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public ClientJpaql<E> addGroupBy(String field) {
        groupBys.add(field);
        return this;
    }

    public ClientJpaql<E> addGroupBy(Class<?> classEntity) {
        groupBys.add(JpaUtils.aliasEntity(classEntity));
        return this;
    }

    public ClientJpaql<E> addGroupBy(Attribute<? super E, ?> singularAttribute) {
        groupBys.add(singularAttribute.getName());
        return this;
    }

    public ClientJpaql<E> addAggregate(IAggregate<E> aggregate) {
        aggregates.add(aggregate);
        return this;
    }

    public ClientJpaql<E> orderByAsc(String field) {
        orderBys.add(FieldOrder.asc(field));
        return this;
    }

    public ClientJpaql<E> orderByDesc(String field) {
        orderBys.add(FieldOrder.desc(field));
        return this;
    }

    public ClientJpaql<E> orderByAsc(Class<?> classEntity) {
        orderByAsc(JpaUtils.aliasEntity(classEntity));
        return this;
    }

    public ClientJpaql<E> orderByDesc(Class<?> classEntity) {
        orderByDesc(JpaUtils.aliasEntity(classEntity));
        return this;
    }

    public ClientJpaql<E> orderByAsc(Attribute<? super E, ?> singularAttribute) {
        orderByAsc(singularAttribute.getName());
        return this;
    }

    public ClientJpaql<E> orderByDesc(Attribute<? super E, ?> singularAttribute) {
        orderByDesc(singularAttribute.getName());
        return this;
    }

    public ClientJpaql<E> entityGraph(String entityGraph) {
        this.entityGraph = entityGraph;
        return this;
    }

    public ClientJpaql<E> entityGraph(String entityGraph, EntityGraphType graphType) {
        this.entityGraph = entityGraph;
        this.graphType = graphType;
        return this;
    }

//    public ClientJpaql<E> fetchJoin(String field) {
//        joinFetchs.add(JoinFetch.join(field));
//        return this;
//    }

    public ClientJpaql<E> fetchJoin(Attribute<? super E, ?> field, AliasJpaql alias) {
        joinFetchs.add(JoinFetch.join(field, alias));
        return this;
    }

//    public ClientJpaql<E> fetchJoin(SetAttribute<? super E, ?> field, AliasJpaql alias) {
//        joinFetchs.add(JoinFetch.join(field, alias));
//        return this;
//    }

    public ClientJpaql<E> fetchJoin(AliasJpaql fromAlias, Attribute<?, ?> field) {
        joinFetchs.add(JoinFetch.join(fromAlias, field));
        return this;
    }

//    public ClientJpaql<E> fetchJoin(AliasJpaql fromAlias, SetAttribute<?, ?> field) {
//        joinFetchs.add(JoinFetch.join(fromAlias, field));
//        return this;
//    }

    public ClientJpaql<E> fetchJoin(AliasJpaql fromAlias, Attribute<?, ?> field, AliasJpaql newAlias) {
        joinFetchs.add(JoinFetch.join(fromAlias, field, newAlias));
        return this;
    }

//    public ClientJpaql<E> fetchJoin(AliasJpaql fromAlias, SetAttribute<?, ?> field, AliasJpaql newAlias) {
//        joinFetchs.add(JoinFetch.join(fromAlias, field, newAlias));
//        return this;
//    }

    public ClientJpaql<E> fetchJoin(Attribute<? super E, ?> singularAttribute) {
        joinFetchs.add(JoinFetch.join(singularAttribute));
        return this;
    }

//    public ClientJpaql<E> fetchJoin(SetAttribute<? super E, ?> setAttribute) {
//        joinFetchs.add(JoinFetch.join(setAttribute));
//        return this;
//    }

//    public ClientJpaql<E> fetchJoin(ListAttribute<? super E, ?> setAttribute) {
//        joinFetchs.add(JoinFetch.join(setAttribute));
//        return this;
//    }

//    public ClientJpaql<E> fetchLeftJoin(String field) {
//        joinFetchs.add(JoinFetch.left(field));
//        return this;
//    }

    public ClientJpaql<E> fetchLeftJoin(Attribute<? super E, ?>  field, AliasJpaql alias) {
        joinFetchs.add(JoinFetch.left(field, alias));
        return this;
    }

//    public ClientJpaql<E> fetchLeftJoin(SetAttribute<? super E, ?>  field, AliasJpaql alias) {
//        joinFetchs.add(JoinFetch.left(field, alias));
//        return this;
//    }

    public ClientJpaql<E> fetchLeftJoin(AliasJpaql fromAlias, Attribute<?, ?> field) {
        joinFetchs.add(JoinFetch.left(fromAlias, field));
        return this;
    }

//    public ClientJpaql<E> fetchLeftJoin(AliasJpaql fromAlias, SetAttribute<?, ?> field) {
//        joinFetchs.add(JoinFetch.left(fromAlias, field));
//        return this;
//    }

    public ClientJpaql<E> fetchLeftJoin(AliasJpaql fromAlias, Attribute<?, ?>  field, AliasJpaql newAlias) {
        joinFetchs.add(JoinFetch.left(fromAlias, field, newAlias));
        return this;
    }

//    public ClientJpaql<E> fetchLeftJoin(AliasJpaql fromAlias, SingularAttribute<?, ?> field, AliasJpaql newAlias) {
//        joinFetchs.add(JoinFetch.left(fromAlias, field, newAlias));
//        return this;
//    }

//    public ClientJpaql<E> fetchLeftJoin(AliasJpaql fromAlias, SetAttribute<?, ?> field, AliasJpaql newAlias) {
//        joinFetchs.add(JoinFetch.left(fromAlias, field, newAlias));
//        return this;
//    }

    public ClientJpaql<E> fetchLeftJoin(Attribute<? super E, ?> attribute) {
        joinFetchs.add(JoinFetch.left(attribute));
        return this;
    }

//    public ClientJpaql<E> fetchLeftJoin(SingularAttribute<? super E, ?> attribute) {
//        joinFetchs.add(JoinFetch.left(attribute));
//        return this;
//    }
//
//    public ClientJpaql<E> fetchLeftJoin(SetAttribute<? super E, ?> setAttribute) {
//        joinFetchs.add(JoinFetch.left(setAttribute));
//        return this;
//    }

}