package br.com.jarch.jpa.api;

import br.com.jarch.model.IBaseEntity;

import javax.persistence.metamodel.Attribute;
import java.util.Optional;

public class JoinFetch<E extends IBaseEntity>  {

    private Optional<String> fromAlias = Optional.empty();

    private String field;

    private Optional<String> newAlias = Optional.empty();

    private boolean left = true;

    JoinFetch(Attribute<?, ?> singularAttribute, boolean left) {
        field = singularAttribute.getName();
        this.left = left;
    }

//    JoinFetch(SetAttribute<?, ?> setAttribute, boolean left) {
//        field = setAttribute.getName();
//        this.left = left;
//    }

//    JoinFetch(ListAttribute<? super E, ?> listAttribute, boolean left) {
//        field = listAttribute.getName();
//        this.left = left;
//    }

//    JoinFetch(String field, boolean left) {
//        this.field = field;
//        this.left = left;
//    }

    JoinFetch(Attribute<? super E, ?> field, Optional<String> newAlias, boolean left) {
        this.field = field.getName();
        this.newAlias = newAlias;
        this.left = left;
    }

//    JoinFetch(SetAttribute<? super E, ?> field, Optional<String> newAlias, boolean left) {
//        this.field = field.getName();
//        this.newAlias = newAlias;
//        this.left = left;
//    }

    JoinFetch(Optional<String> fromAlias, Attribute<?, ?>  field, Optional<String> newAlias, boolean left) {
        this.fromAlias = fromAlias;
        this.field = field.getName();
        this.newAlias = newAlias;
        this.left = left;
    }

//    JoinFetch(Optional<String> fromAlias, SetAttribute<?, ?>  field, Optional<String> newAlias, boolean left) {
//        this.fromAlias = fromAlias;
//        this.field = field.getName();
//        this.newAlias = newAlias;
//        this.left = left;
//    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Optional<String> getFromAlias() {
        return fromAlias;
    }

//    public void setFromAlias(Optional<String> fromAlias) {
//        this.fromAlias = fromAlias;
//    }

    public Optional<String> getNewAlias() {
        return newAlias;
    }

//    public void setNewAlias(Optional<String> newAlias) {
//        this.newAlias = newAlias;
//    }

    public boolean isLeft() {
        return left;
    }

//    @Deprecated
//    public static <E extends IBaseEntity> JoinFetch<E> of(String field) {
//        return new JoinFetch<>(field, true);
//    }

//    @Deprecated
//    public static <E extends IBaseEntity> JoinFetch<E> of(String field, String newAlias) {
//        return new JoinFetch<>(field, Optional.of(newAlias), true);
//    }

//    @Deprecated
//    public static <E extends IBaseEntity> JoinFetch<E> of(AliasJpaql fromAlias, String field, AliasJpaql newAlias) {
//        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.of(newAlias.getValue()), true);
//    }

//    @Deprecated
//    public static <E extends IBaseEntity> JoinFetch<E> of(Attribute<? super E, ?> singularAttribute) {
//        return new JoinFetch<>(singularAttribute, true);
//    }

//    @Deprecated
//    public static <E extends IBaseEntity> JoinFetch<E> of(SetAttribute<? super E, ?> setAttribute) {
//        return new JoinFetch<>(setAttribute, true);
//    }

//    public static <E extends IBaseEntity> JoinFetch<E> left(String field) {
//        return new JoinFetch<>(field, true);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> left(Attribute<? super E, ?>  field, AliasJpaql newAlias) {
        return new JoinFetch<>(field, Optional.of(newAlias.getValue()), true);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> left(SetAttribute<? super E, ?>  field, AliasJpaql newAlias) {
//        return new JoinFetch<>(field, Optional.of(newAlias.getValue()), true);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> left(AliasJpaql fromAlias, Attribute<?, ?> field) {
        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.empty(), true);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> left(AliasJpaql fromAlias, SetAttribute<?, ?> field) {
//        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.empty(), true);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> left(AliasJpaql fromAlias, Attribute<?, ?> field, AliasJpaql newAlias) {
        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.of(newAlias.getValue()), true);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> left(AliasJpaql fromAlias, SetAttribute<?, ?> field, AliasJpaql newAlias) {
//        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.of(newAlias.getValue()), true);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> left(Attribute<? super E, ?> singularAttribute) {
        return new JoinFetch<>(singularAttribute, true);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> left(SetAttribute<? super E, ?> setAttribute) {
//        return new JoinFetch<>(setAttribute, true);
//    }

//    public static <E extends IBaseEntity> JoinFetch<E> join(String field) {
//        return new JoinFetch<>(field, false);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> join(Attribute<? super E, ?> field, AliasJpaql newAlias) {
        return new JoinFetch<>(field, Optional.of(newAlias.getValue()), false);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> join(SetAttribute<? super E, ?> field, AliasJpaql newAlias) {
//        return new JoinFetch<>(field, Optional.of(newAlias.getValue()), false);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> join(AliasJpaql fromAlias, Attribute<? super E, ?> field) {
        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.empty(), false);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> join(AliasJpaql fromAlias, SetAttribute<? super E, ?> field) {
//        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.empty(), false);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> join(AliasJpaql fromAlias, Attribute<? super E, ?> field, AliasJpaql newAlias) {
        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.of(newAlias.getValue()), false);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> join(AliasJpaql fromAlias, SetAttribute<? super E, ?> field, AliasJpaql newAlias) {
//        return new JoinFetch<>(Optional.of(fromAlias.getValue()), field, Optional.of(newAlias.getValue()), false);
//    }

    public static <E extends IBaseEntity> JoinFetch<E> join(Attribute<? super E, ?> singularAttribute) {
        return new JoinFetch<>(singularAttribute, false);
    }

//    public static <E extends IBaseEntity> JoinFetch<E> join(SetAttribute<? super E, ?> setAttribute) {
//        return new JoinFetch<>(setAttribute, false);
//    }

//    public static <E extends IBaseEntity> JoinFetch<E> join(ListAttribute<? super E, ?> listAttribute) {
//        return new JoinFetch<>(listAttribute, false);
//    }
}
