package br.com.jarch.jpa.api;

import br.com.jarch.model.IBaseEntity;
import br.com.jarch.jpa.param.ParamFieldValue;

public final class OperatorJpaql<E extends IBaseEntity> {

    private ClientJpaql<E> clientJpaql;

    OperatorJpaql(ClientJpaql<E> clientJpaql) {
        this.clientJpaql = clientJpaql;
    }

    public WhereJpaql<E> and() {
        return new WhereJpaql<>(clientJpaql, ParamFieldValue.OperatorType.AND);
    }

    public WhereJpaql<E> and(boolean ifCondition) {
        if (!ifCondition) {
            return clientJpaql.where();
        }

        return new WhereJpaql<>(clientJpaql, ParamFieldValue.OperatorType.AND);
    }

    public WhereJpaql<E> or() {
        return new WhereJpaql<>(clientJpaql, ParamFieldValue.OperatorType.OR);
    }

    public WhereJpaql<E> or(boolean ifCondition) {
        if (!ifCondition) {
            return clientJpaql.where();
        }

        return new WhereJpaql<>(clientJpaql, ParamFieldValue.OperatorType.OR);
    }

    public OperatorJpaql<E> closeParenthesis() {
        clientJpaql.paramFieldValues.setEndOperatorLogicLastParamFieldValue(")");
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> closeParenthesis(boolean ifCondition) {
        if (ifCondition) {
            clientJpaql.paramFieldValues.setEndOperatorLogicLastParamFieldValue(")");
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public CollectorJpaql<E> collect() {
        return new CollectorJpaql<>(clientJpaql);
    }
}
