package br.com.jarch.jpa.api;

import br.com.jarch.jpa.param.MapParamValue;
import br.com.jarch.jpa.param.ParamFieldValue;
import br.com.jarch.model.IBaseEntity;
import br.com.jarch.util.JpaUtils;
import br.com.jarch.util.type.ConditionSearchType;

import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import java.util.Collection;

public final class WhereJpaql<E extends IBaseEntity> {

    private ClientJpaql<E> clientJpaql;

    private String startOperatorLogic;

    private ParamFieldValue.OperatorType operator;

    WhereJpaql(ClientJpaql<E> clientJpaql, ParamFieldValue.OperatorType operator) {
        this.clientJpaql = clientJpaql;
        this.operator = operator;
        this.startOperatorLogic = "";
    }

    WhereJpaql(ClientJpaql<E> clientJpaql, ParamFieldValue.OperatorType operator, String startOperatorLogic) {
        this.clientJpaql = clientJpaql;
        this.operator = operator;
        this.startOperatorLogic = startOperatorLogic;
    }

    public OperatorJpaql<E> equalsTo(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return equalsTo(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> equalsTo(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute, T value) {
        return equalsTo(ifCondition, singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> equalsTo(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.EQUAL, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> equalsTo(Class<? extends IBaseEntity> classEntity, Object value) {
        return equalsTo(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> equalsTo(SingularAttribute<? super E, T> singularAttribute, T value) {
        return equalsTo(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> equalsTo(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return equalsTo(singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> notEqualsTo(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return notEqualsTo(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notEqualsTo(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.DIFFERENT, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notEqualsTo(boolean ifCondition, Class<? extends IBaseEntity> classEntity, T value) {
        if (ifCondition) {
            return notEqualsTo(JpaUtils.aliasEntity(classEntity), value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notEqualsTo(Class<? extends IBaseEntity> classEntity, T value) {
        return notEqualsTo(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> notEqualsTo(SingularAttribute<? super E, T> singularAttribute, T value) {
        return notEqualsTo(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> notEqualsTo(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return notEqualsTo(singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> greaterThan(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return greaterThan(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }


    public OperatorJpaql<E> greaterThan(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.LARGER, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> greaterThan(Class<? extends IBaseEntity> classEntity, T value) {
        return greaterThan(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> greaterThan(SingularAttribute<? super E, T> singularAttribute, T value) {
        return greaterThan(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> greaterThan(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return greaterThan(singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> greaterOrEqualsThan(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return greaterOrEqualsThan(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> greaterOrEqualsThan(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute, T value) {
        return greaterOrEqualsThan(ifCondition, singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> greaterOrEqualsThan(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.LARGER_EQUAL, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> greaterOrEqualsThan(Class<? extends IBaseEntity> classEntity, T value) {
        return greaterOrEqualsThan(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> greaterOrEqualsThan(SingularAttribute<? super E, T> singularAttribute, T value) {
        return greaterOrEqualsThan(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> greaterOrEqualsThan(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return greaterOrEqualsThan(singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> lessThan(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return lessThan(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }


    public OperatorJpaql<E> lessThan(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.LESS, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> lessThan(Class<? extends IBaseEntity> classEntity, T value) {
        return lessThan(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> lessThan(SingularAttribute<? super E, T> singularAttribute, T value) {
        return lessThan(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> lessThan(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return lessThan(singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> lessOrEqualsThan(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return lessOrEqualsThan(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> lessOrEqualsThan(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute, T value) {
        return lessOrEqualsThan(ifCondition, singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> lessOrEqualsThan(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.LESS_EQUAL, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> lessOrEqualsThan(Class<? extends IBaseEntity> classEntity, T value) {
        return lessOrEqualsThan(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> lessOrEqualsThan(SingularAttribute<? super E, T> singularAttribute, T value) {
        return lessOrEqualsThan(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> lessOrEqualsThan(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return lessOrEqualsThan(singularAttribute.getName(), value);
    }

    public OperatorJpaql<E> contains(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return contains(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }


    public OperatorJpaql<E> contains(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.CONTAINS, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> contains(Class<? extends IBaseEntity> classEntity, T value) {
        return contains(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> contains(SingularAttribute<? super E, T> singularAttribute, T value) {
        return contains(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> contains(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return contains(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> contains(PluralAttribute<? super E, T, ?> collectionAttribute, Collection<T> value) {
        return contains(collectionAttribute.getName(), value);
    }

    public OperatorJpaql<E> notContains(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return notContains(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notContains(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.NOT_CONTAINS, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notContains(Class<? extends IBaseEntity> classEntity, Object value) {
        String alias = JpaUtils.aliasEntity(classEntity);
        clientJpaql.paramFieldValues.add(operator, alias, ConditionSearchType.NOT_CONTAINS, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notContains(SingularAttribute<? super E, T> singularAttribute, T value) {
        return notContains(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> notContains(SingularAttribute<? super E, T> singularAttribute, Collection<T> value) {
        return notContains(singularAttribute.getName(), value);
    }

    public <T> OperatorJpaql<E> notContains(PluralAttribute<? super E, T, ?> collectionAttribute, Collection<T> value) {
        return notContains(collectionAttribute.getName(), value);
    }

    public OperatorJpaql<E> jpql(boolean ifCondition, String jpql) {
        if (ifCondition) {
            return jpql(jpql);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> jpql(String jpql) {
        return jpql(jpql, null);
    }

    public OperatorJpaql<E> jpql(boolean ifCondition, String jpql, MapParamValue mapParamValue) {
        if (ifCondition) {
            return jpql(jpql, mapParamValue);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> jpql(String jpql, MapParamValue mapParamValue) {
        ParamFieldValue paramFieldValueConcatWhere = new ParamFieldValue();
        paramFieldValueConcatWhere.setOperator(operator);
        paramFieldValueConcatWhere.setConditionSearch(ConditionSearchType.JPAQL);
        paramFieldValueConcatWhere.setClause(jpql);
        paramFieldValueConcatWhere.setStartOperatorLogic(startOperatorLogic);

        if (mapParamValue != null) {
            mapParamValue
                    .entrySet()
                    .forEach(m -> paramFieldValueConcatWhere.addParamValue(m.getKey(), m.getValue()));
        }

        clientJpaql.paramFieldValues.add(paramFieldValueConcatWhere);

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> exists(boolean ifCondition, String field) {
        if (ifCondition) {
            return exists(field);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> exists(String field) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.EXISTS, null, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> exists(boolean ifCondition, Class<? extends IBaseEntity> classEntity) {
        if (ifCondition) {
            return exists(classEntity);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> exists(Class<? extends IBaseEntity> classEntity) {
        return exists(JpaUtils.aliasEntity(classEntity));
    }

    public <T> OperatorJpaql<E> exists(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute) {
        if (ifCondition) {
            return exists(singularAttribute);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> exists(SingularAttribute<? super E, T> singularAttribute) {
        return exists(singularAttribute.getName());
    }

    public OperatorJpaql<E> notExists(boolean ifCondition, String field) {
        if (ifCondition) {
            return notExists(field);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notExists(String field) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.NOT_EXISTS, null, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notExists(boolean ifCondition, Class<? extends IBaseEntity> classEntity) {
        if (ifCondition) {
            return notExists(classEntity);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notExists(Class<? extends IBaseEntity> classEntity) {
        return notExists(JpaUtils.aliasEntity(classEntity));
    }

    public <T> OperatorJpaql<E> notExists(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute) {
        if (ifCondition) {
            return notExists(singularAttribute);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notExists(SingularAttribute<? super E, T> singularAttribute) {
        return notExists(singularAttribute.getName());
    }

    public OperatorJpaql<E> isNull(boolean ifCondition, String field) {
        if (ifCondition) {
            return isNotNull(field);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> isNull(String field) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.EQUAL, null, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> isNull(boolean ifCondition, Class<? extends IBaseEntity> classEntity) {
        if (ifCondition) {
            return isNull(classEntity);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> isNull(Class<? extends IBaseEntity> classEntity) {
        return isNull(JpaUtils.aliasEntity(classEntity));
    }

    public <T> OperatorJpaql<E> isNull(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute) {
        if (ifCondition) {
            return isNull(singularAttribute);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> isNull(SingularAttribute<? super E, T> singularAttribute) {
        return isNull(singularAttribute.getName());
    }

    public OperatorJpaql<E> isNotNull(boolean ifCondition, String field) {
        if (ifCondition) {
            return isNotNull(field);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> isNotNull(String field) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.DIFFERENT, null, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> isNotNull(boolean ifCondition, Class<? extends IBaseEntity> classEntity) {
        if (ifCondition) {
            return isNotNull(classEntity);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> isNotNull(Class<? extends IBaseEntity> classEntity) {
        return isNotNull(JpaUtils.aliasEntity(classEntity));
    }

    public <T> OperatorJpaql<E> isNotNull(boolean ifCondition, SingularAttribute<? super E, T> singularAttribute) {
        if (ifCondition) {
            return isNotNull(singularAttribute);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> isNotNull(SingularAttribute<? super E, T> singularAttribute) {
        return isNotNull(singularAttribute.getName());
    }

    public OperatorJpaql<E> collectionEmpty(boolean ifCondition, String field) {
        if (ifCondition) {
            return collectionEmpty(field);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> collectionEmpty(String field) {
        return notExists(field);
    }

    public OperatorJpaql<E> collectionEmpty(boolean ifCondition, Class<? extends IBaseEntity> classEntity) {
        if (ifCondition) {
            return collectionEmpty(classEntity);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> collectionEmpty(Class<? extends IBaseEntity> classEntity) {
        return collectionEmpty(JpaUtils.aliasEntity(classEntity));
    }

    public <T> OperatorJpaql<E> collectionEmpty(boolean ifCondition, PluralAttribute<E, T, ?> pluralAttribute) {
        if (ifCondition) {
            return collectionEmpty(pluralAttribute);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> collectionEmpty(PluralAttribute<E, T, ?> pluralAttribute) {
        return collectionEmpty(pluralAttribute.getName());
    }

    public OperatorJpaql<E> notCollectionEmpty(boolean ifCondition, String field) {
        if (ifCondition) {
            return notCollectionEmpty(field);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notCollectionEmpty(String field) {
        return exists(field);
    }

    public OperatorJpaql<E> notCollectionEmpty(boolean ifCondition, Class<? extends IBaseEntity> classEntity) {
        if (ifCondition) {
            return notCollectionEmpty(classEntity);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notCollectionEmpty(Class<? extends IBaseEntity> classEntity) {
        return notCollectionEmpty(JpaUtils.aliasEntity(classEntity));
    }

    public <T> OperatorJpaql<E> notCollectionEmpty(boolean ifCondition, PluralAttribute<E, T, ?> pluralAttribute) {
        if (ifCondition) {
            return notCollectionEmpty(pluralAttribute);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notCollectionEmpty(PluralAttribute<E, T, ?> pluralAttribute) {
        return notCollectionEmpty(pluralAttribute.getName());
    }

    public OperatorJpaql<E> memberOf(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return memberOf(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> memberOf(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.MEMBER_OF, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> memberOf(boolean ifCondition, Class<? extends IBaseEntity> classEntity, T value) {
        if (ifCondition) {
            return memberOf(classEntity, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> memberOf(Class<? extends IBaseEntity> classEntity, T value) {
        return memberOf(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> memberOf(boolean ifCondition, PluralAttribute<E, T, ?> pluralAttribute, T value) {
        if (ifCondition) {
            return memberOf(pluralAttribute, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> memberOf(PluralAttribute<E, T, ?> pluralAttribute, T value) {
        return memberOf(pluralAttribute.getName(), value);
    }

    public OperatorJpaql<E> notMemberOf(boolean ifCondition, String field, Object value) {
        if (ifCondition) {
            return notMemberOf(field, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public OperatorJpaql<E> notMemberOf(String field, Object value) {
        clientJpaql.paramFieldValues.add(operator, field, ConditionSearchType.EXISTS, value, startOperatorLogic);
        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notMemberOf(boolean ifCondition, Class<? extends IBaseEntity> classEntity, T value) {
        if (ifCondition) {
            return notMemberOf(classEntity, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notMemberOf(Class<? extends IBaseEntity> classEntity, T value) {
        return notMemberOf(JpaUtils.aliasEntity(classEntity), value);
    }

    public <T> OperatorJpaql<E> notMemberOf(boolean ifCondition, PluralAttribute<E, T, ?> pluralAttribute, T value) {
        if (ifCondition) {
            return notMemberOf(pluralAttribute, value);
        }

        return new OperatorJpaql<>(clientJpaql);
    }

    public <T> OperatorJpaql<E> notMemberOf(PluralAttribute<E, T, ?> pluralAttribute, T value) {
        return notMemberOf(pluralAttribute.getName(), value);
    }

    public WhereJpaql<E> openParenthesis() {
        startOperatorLogic += "(";
        return new WhereJpaql<>(clientJpaql, operator, startOperatorLogic);
    }

    public WhereJpaql<E> openParenthesis(boolean ifCondition) {
        if (ifCondition) {
            startOperatorLogic += "(";
        }

        return new WhereJpaql<>(clientJpaql, operator, startOperatorLogic);
    }
}
