package br.com.jarch.jpa.converter;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

@Converter(/*autoApply = true*/)
public class LocalTimeJpaConverter implements AttributeConverter<LocalTime, String> {

    @Override
    public String convertToDatabaseColumn(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }

        return localTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    @Override
    public LocalTime convertToEntityAttribute(String date) {
        if (date == null) {
            return null;
        }

        try {
            return LocalTime.parse(date, DateTimeFormatter.ofPattern("HH:mm:ss"));
        } catch (Exception ex) {
            return LocalTime.parse(date, DateTimeFormatter.ofPattern("HH:mm"));
        }
    }
}