package br.com.jarch.jpa.converter.br;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

/**
 * Created by wagner.araujo on 09/12/15.
 */
@Converter(/*autoApply = true*/)
public class BooleanSNJpaConverter implements AttributeConverter<Boolean, String> {

    @Override
    public String convertToDatabaseColumn(Boolean attribute) {
        if (attribute == null) {
            return null;
        }

        return (attribute ? "S" : "N");
    }

    @Override
    public Boolean convertToEntityAttribute(String boolStr) {
        if (boolStr == null) {
            return null;
        }

        return "S".equals(boolStr);
    }
}
