package br.com.jarch.jpa.param;

import br.com.jarch.model.IBaseEntity;
import br.com.jarch.util.type.ConditionSearchType;

import java.util.Map;

/**
 * Created by wagner.araujo on 8/19/16.
 */
public final class ParamFieldValueBuilder<E extends IBaseEntity> {

    private ParamFieldValues paramFieldValues;

    private ParamFieldValueBuilder(Class<E> classEntity) {
        paramFieldValues = new ParamFieldValues(classEntity);
    }

    public static <E extends IBaseEntity> ParamFieldValueBuilder newInstance(Class<E> classEntity) {
        return new ParamFieldValueBuilder(classEntity);
    }

    public ParamFieldValueBuilder addFieldValueEqual(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.EQUAL, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueEqual(String attribute, Object value, boolean caseSensitive) {
        paramFieldValues.add(create(attribute, ConditionSearchType.EQUAL, value, caseSensitive));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueLarger(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.LARGER, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueLess(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.LESS, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueDifferent(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.DIFFERENT, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueLargerEqual(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.LARGER_EQUAL, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueLessEqual(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.LESS_EQUAL, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueContains(String attribute, Object value) {
        paramFieldValues.add(create(attribute, ConditionSearchType.CONTAINS, value));
        return this;
    }

    public ParamFieldValueBuilder addFieldValueNotContains(String attribute, Object value) {
        paramFieldValues
                .add(create(attribute, ConditionSearchType.NOT_CONTAINS, value));
        return this;
    }

    public ParamFieldValueBuilder addExistsField(String attribute) {
        paramFieldValues.add(create(attribute, ConditionSearchType.EXISTS));
        return this;
    }

    public ParamFieldValueBuilder addNotExistsField(String attribute) {
        paramFieldValues.add(create(attribute, ConditionSearchType.NOT_EXISTS));
        return this;
    }

    public ParamFieldValueBuilder addConcatWhere(String where) {
        return addConcatWhere(where, null);
    }

    public ParamFieldValueBuilder addConcatWhere(String where, Map<String, Object> paramValues) {
        return addJpaql(where, paramValues);
    }

    public ParamFieldValueBuilder addJpaql(String where) {
        return addJpaql(where, null);
    }

    public ParamFieldValueBuilder addJpaql(String where, Map<String, Object> paramValues) {
        ParamFieldValue paramFieldValueConcatWhere = new ParamFieldValue();
        paramFieldValueConcatWhere.setConditionSearch(ConditionSearchType.JPAQL);
        paramFieldValueConcatWhere.setClause(where);

        if (paramValues != null) {
            paramValues
                    .entrySet()
                    .forEach(m -> paramFieldValueConcatWhere.addParamValue(m.getKey(), m.getValue()));
        }

        paramFieldValues.add(paramFieldValueConcatWhere);

        return this;
    }

    public ParamFieldValues build() {
        return paramFieldValues;
    }

    private ParamFieldValue create(String attribute, ConditionSearchType conditionSearch) {
        return create(attribute, conditionSearch, null, true);
    }

    private ParamFieldValue create(String attribute, ConditionSearchType conditionSearch, Object value) {
        return create(attribute, conditionSearch, value, true);
    }

    private ParamFieldValue create(String attribute, ConditionSearchType conditionSearch, Object value, boolean caseSensitive) {
        ParamFieldValue paramFieldValue = new ParamFieldValue();
        paramFieldValue.setAttribute(attribute);
        paramFieldValue.setConditionSearch(conditionSearch);
        paramFieldValue.setValue(value);
        paramFieldValue.setCaseSensitive(caseSensitive);
        return paramFieldValue;
    }
}
