package br.com.jarch.jpa.param;

import br.com.jarch.annotation.JArchExclusionLogic;
import br.com.jarch.model.IBaseEntity;
import br.com.jarch.model.IMultiTenantEntity;
import br.com.jarch.model.MultiTenant;
import br.com.jarch.util.type.ConditionSearchType;

import javax.enterprise.inject.spi.CDI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParamFieldValues {

    private List<ParamFieldValue> paramFieldValues;

//    public ParamFieldValues() {
//        paramFieldValues = new ArrayList<>();
//    }

    public ParamFieldValues(Class<? extends IBaseEntity> classEntity) {
        paramFieldValues = new ArrayList<>();

        //TODO: Wagner - Quando a chamada e feita via @Schedule com a anotacao @TransactionAttribute na classe do job ou no metodo com @Schedule o filtro do tenant nao e ativado (deve ser algum bug do Hibernate)
        //               Para contornar esse o filtro abaixo e adicionado
        MultiTenant multiTenant = CDI.current().select(MultiTenant.class).get();

        if (!multiTenant.isSession() && IMultiTenantEntity.class.isAssignableFrom(classEntity)) {
            addFilterMultiTenant();
        }

        if (!multiTenant.isSession() && classEntity.isAnnotationPresent(JArchExclusionLogic.class)) {
            addFilterExclusionLogic();
        }

    }

    public void add(ParamFieldValue paramFieldValue) {
        paramFieldValue.setNameParameterJpaql(paramFieldValues.size());
        paramFieldValues.add(paramFieldValue);
    }

    public void add(ParamFieldValue.OperatorType operator, String field, ConditionSearchType conditionSearch, Object value, String startOperatorLogic) {
        ParamFieldValue paramFieldValue = new ParamFieldValue(operator);
        paramFieldValue.setStartOperatorLogic(startOperatorLogic);
        paramFieldValue.setAttribute(field);
        paramFieldValue.setConditionSearch(conditionSearch);
        paramFieldValue.setValue(value);
        add(paramFieldValue);
    }

    public void addFilterMultiTenant() {
        add(ParamFieldValue.OperatorType.AND, "multiTenantId", ConditionSearchType.EQUAL, CDI.current().select(MultiTenant.class).get().get(), "");
    }

    public void addFilterExclusionLogic() {
        add(ParamFieldValue.OperatorType.AND, "dateHourLogicExclusion", ConditionSearchType.EQUAL, null, "");
    }

    public List<ParamFieldValue> get() {
        return Collections.unmodifiableList(paramFieldValues);
    }

    public void setEndOperatorLogicLastParamFieldValue(String operatorLogic) {
        ParamFieldValue paramFieldValue = paramFieldValues.get(paramFieldValues.size() - 1);
        paramFieldValue.setEndOperatorLogic(paramFieldValue.getEndOperatorLogic() + operatorLogic);
    }

}
