package br.com.jarch.jpa.type;

import br.com.jarch.model.type.OrderType;

public final class FieldOrder {

    private String field;

    private OrderType order;

    private FieldOrder(String field, OrderType order) {
        this.field = field;
        this.order = order;
    }

    public static FieldOrder asc(String field) {
        return new FieldOrder(field, OrderType.ASC);
    }

    public static FieldOrder desc(String field) {
        return new FieldOrder(field, OrderType.DESC);
    }

    public String getField() {
        return field;
    }

    public OrderType getOrder() {
        return order;
    }

    public boolean isAsc() {
        return OrderType.ASC.equals(order);
    }

    public boolean isDesc() {
        return OrderType.DESC.equals(order);
    }

}
