package br.com.jarch.jpa.util;

import br.com.jarch.annotation.JArchJoinFetch;
import br.com.jarch.jpa.api.JoinFetch;
import br.com.jarch.util.JpaUtils;

import javax.persistence.JoinColumn;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class ClauseFromUtils {

    public static final String FROM = "FROM";

    private ClauseFromUtils() {

    }

    public static String generateClauseFrom(Class<?> clazz, JoinFetch...joinFetches) {
        return generateClauseFrom(clazz, Arrays.stream(joinFetches).collect(Collectors.toList()));
    }

    public static String generateClauseFrom(Class<?> clazz, List<JoinFetch> joinFetches) {
        return FROM + " " + JpaUtils.nameEntity(clazz) + " " + JpaUtils.aliasEntity(clazz) + " " +
                joinFetches
                        .stream()
                        .map(joinFetch -> (joinFetch.isLeft() ? "LEFT " : "") + "JOIN FETCH " + joinFetch.getFromAlias().orElse(JpaUtils.aliasEntity(clazz))  + "." + joinFetch.getField() + " " + joinFetch.getNewAlias().orElse(joinFetch.getField().replaceAll("\\.", "")))
                        .collect(Collectors.joining(" "));
    }

    public static String generateClauseFrom(Class<?> clazz) {
        return FROM + " " + JpaUtils.nameEntity(clazz) + " " + JpaUtils.aliasEntity(clazz) + " ";
    }

    public static String generateClauseFrom(Class<?> clazz, boolean fetch) {
        String from = FROM + " " + JpaUtils.nameEntity(clazz) + " " + JpaUtils.aliasEntity(clazz) + " ";
        from += generateLeftJoin(clazz, fetch);
        return from;
    }

    private static String generateLeftJoin(Class<?> clazzEvaluate, boolean fetch) {
        StringBuilder leftJoin = new StringBuilder();

        for (Field field : clazzEvaluate.getDeclaredFields()) {
            if (!needJoin(field)) {
                continue;
            }

            String atributo = field.getName();
            JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);

            boolean left = Collection.class.isAssignableFrom(field.getType()) || joinColumn == null || joinColumn.nullable();

            leftJoin.append((left ? "LEFT " : "") + "JOIN " + (fetch ? "FETCH " : " ") + JpaUtils.aliasEntity(clazzEvaluate) + "." + atributo + " " + atributo + " ");
        }

        return leftJoin.toString();
    }

    private static boolean needJoin(Field field) {
        return field.isAnnotationPresent(JArchJoinFetch.class);
    }
}
