package br.com.jarch.jpa.util;

import br.com.jarch.util.JpaUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class ClauseGroupByUtils {

    private ClauseGroupByUtils() {

    }

    public static String generateClauseGroupBy(Class<?> clazzEntity, String groupBy) {
        if (groupBy == null || groupBy == null || groupBy.isEmpty()) {
            return "";
        }

        List<String> listAttributteOrders = new ArrayList<>();

        if (groupBy != null && !groupBy.isEmpty()) {
            listAttributteOrders.add(groupBy);
        }

        return ClauseGroupByUtils.generateClauseGroupBy(clazzEntity, listAttributteOrders);
    }

    public static String generateClauseGroupBy(Class<?> clazzEntity, Collection<String> fields) {
        if (fields == null) {
            return "";
        }

        String aliasEntity = JpaUtils.aliasEntity(clazzEntity);

        String listFields = fields
                .stream()
                .filter(f -> f != null && !f.isEmpty()).map(f -> aliasEntity + "." + f)
                .collect(Collectors.joining(", "));

        if (listFields.isEmpty()) {
            return "";
        }

        return "GROUP BY " + listFields;
    }
}
