package br.com.jarch.jpa.util;

import br.com.jarch.jpa.type.FieldOrder;
import br.com.jarch.model.type.OrderType;
import br.com.jarch.util.JpaUtils;

import java.util.Collection;
import java.util.stream.Collectors;

public final class ClauseOrderByUtils {

    private ClauseOrderByUtils() {

    }

    public static String generateClauseOrderBy(Class<?> clazzEntity, Collection<FieldOrder> attributesOrders) {
        if (attributesOrders.isEmpty()) {
            return "";
        }

        String aliasEntidade = JpaUtils.aliasEntity(clazzEntity);

        return "ORDER BY " +
                attributesOrders
                        .stream()
                        .map(f -> aliasEntidade + "." + f.getField() + " " + (OrderType.ASC.equals(f.getOrder()) ? "" : "DESC"))
                        .collect(Collectors.joining(", "));
    }

//    public static String generateClauseOrderBy(Class<?> clazzEntity, Collection<String> attributesOrders, OrderType order) {
//        StringBuilder orderBy = new StringBuilder("ORDER BY ");
//
//        String aliasEntidade = JpaUtils.aliasEntity(clazzEntity);
//
//        if (attributesOrders.isEmpty()) {
//            orderBy.append(JpaUtils.attributeId(clazzEntity));
//        } else {
//            for (String atributo : attributesOrders) {
//                if (atributo.isEmpty()) {
//                    continue;
//                }
//
//                orderBy.append(aliasEntidade + "." + atributo + ", ");
//            }
//        }
//
//        if (orderBy.toString().endsWith(", ")) {
//            orderBy.delete(orderBy.length() - 2, orderBy.length());
//        }
//
//        if (order == OrderType.DESC) {
//            orderBy.append(" DESC");
//        }
//
//        return orderBy.toString();
//    }
}
