package br.com.jarch.jpa.util;

import br.com.jarch.jpa.param.ParamFieldValue;
import br.com.jarch.jpa.param.ParamFieldValues;

/**
 * Created by wagner.araujo on 1/5/17.
 */
public final class ClauseWhereUtils {

    private ClauseWhereUtils() {

    }

    public static String generateClauseWhere(Class<?> clazzEntity, ParamFieldValues paramFieldValues) {
        StringBuilder commandJpaReturn = new StringBuilder();

        for (ParamFieldValue paramFieldValue : paramFieldValues.get()) {

            if (commandJpaReturn.length() > 0) {
                commandJpaReturn.append(" ").append(paramFieldValue.getOperator());
            }

            if (commandJpaReturn.length() > 0 && !commandJpaReturn.toString().endsWith(" ")) {
                commandJpaReturn.append(" ");
            }

            commandJpaReturn.append(paramFieldValue.getStartOperatorLogic());

            commandJpaReturn.append(paramFieldValue.getConditionSearch().generateConditionWhereJpaql(clazzEntity, paramFieldValue));

            commandJpaReturn.append(paramFieldValue.getEndOperatorLogic());
        }

        if (commandJpaReturn.length() > 0) {
            commandJpaReturn.insert(0, "WHERE ");
        }

        return commandJpaReturn.toString();
    }
}
