package br.com.jarch.jpa.util;

import br.com.jarch.model.MultiTenant;
import org.hibernate.Session;

import javax.persistence.EntityManager;

public class EntityManagerFilterUtils {

    public static void addFilters(EntityManager entityManager, MultiTenant multiTenant) {
        if (entityManager.unwrap(Session.class).getSessionFactory().getDefinedFilterNames().contains("tenant")) {
            entityManager
                    .unwrap(Session.class)
                    .enableFilter("tenant")
                    .setParameter("tenantId", multiTenant.get());

//                    .validate();
        }

        if (entityManager.unwrap(Session.class).getSessionFactory().getDefinedFilterNames().contains("exclusionLogic")) {
            entityManager
                    .unwrap(Session.class)
                    .enableFilter("exclusionLogic");

//                    .validate();
        }
    }
}
