package br.com.jarch.jpa.util;

import br.com.jarch.jpa.param.ParamFieldValue;
import br.com.jarch.jpa.param.ParamFieldValues;
import br.com.jarch.util.type.ConditionSearchType;

import javax.persistence.Query;
import java.util.Map;

public final class ValueWhereUtils {
    private ValueWhereUtils() {
    }

    public static void addValueParam(Query query, ParamFieldValues paramFieldValues) {
        setParamValue(query, paramFieldValues);
    }

    public static void addValueParam(Query query, Map<String, Object> paramValues) {
        paramValues
                .entrySet()
                .forEach(p -> query.setParameter(p.getKey(), p.getValue()));
    }

    private static void setParamValue(Query query, ParamFieldValues paramFieldValues) {
        paramFieldValues
                .get()
                .stream()
                .filter(ParamFieldValue::isHasParam)
                .forEach(p -> query.setParameter(p.getNameParameterJpaql(), p.getValue()));

        paramFieldValues
                .get()
                .stream()
                .filter(p -> ConditionSearchType.JPAQL.equals(p.getConditionSearch()))
                .forEach(p -> p
                        .getParamValue()
                        .entrySet()
                        .forEach(m -> query.setParameter(m.getKey(), m.getValue())));
    }
}
