/*
 * Decompiled with CFR 0.152.
 */
package br.com.moip.jcurtain;

import br.com.moip.jcurtain.Feature;
import java.net.URI;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public class JCurtain {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCurtain.class);
    private JedisPool jedisPool;

    public JCurtain(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public JCurtain(URI uri) {
        this.jedisPool = new JedisPool(uri);
    }

    public boolean isOpen(String feature) {
        try {
            return this.isFeatureOpen(feature);
        }
        catch (JedisException e) {
            LOGGER.error("[JCurtain] Redis error. Returning default value FALSE for [feature=" + feature + "]", (Throwable)e);
            return false;
        }
    }

    public boolean isOpen(String feature, String user) {
        try {
            return this.isOpenForUser(feature, user) || this.isFeatureOpen(feature);
        }
        catch (JedisException e) {
            LOGGER.error("[JCurtain] Redis error. Returning default value FALSE for [feature=" + feature + "]", (Throwable)e);
            return false;
        }
    }

    public void openFeatureForUser(String feature, String user) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.sadd("feature:" + feature + ":users", new String[]{user});
        }
        catch (JedisException e) {
            LOGGER.error("[JCurtain] Redis error. Returning default value FALSE for [user=" + user + ",feature=" + feature + "]", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Feature getFeature(String name) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Feature feature = new Feature(name, this.getFeaturePercentage(name), jedis.smembers("feature:" + name + ":users"));
            return feature;
        }
        catch (JedisException e) {
            LOGGER.error("[JCurtain] Redis error. Returning default value FALSE for [feature=" + (Object)((Object)e) + "]", (Throwable)e);
            return null;
        }
    }

    private boolean isOpenForUser(String feature, String user) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.sismember("feature:" + feature + ":users", user);
            return bl;
        }
    }

    private int getFeaturePercentage(String feature) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String featurePercentage = jedis.get("feature:" + feature + ":percentage");
            int n = featurePercentage == null ? 0 : Integer.parseInt(featurePercentage);
            return n;
        }
    }

    private boolean isFeatureOpen(String feature) {
        return this.randomPercentage() <= this.getFeaturePercentage(feature);
    }

    private int randomPercentage() {
        return new Random().nextInt(100) + 1;
    }
}

