/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.jabuticava;

import br.com.objectos.core.lang.Strings;
import br.com.objectos.jabuticava.ExcecaoDeCepInvalido;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Cep {
    private static final Pattern regex = Pattern.compile("^([0-9]{5})-?([0-9]{3})$");
    private static final Cep VAZIO = new CepVazio();
    private final int prefixo;
    private final short sufixo;

    private Cep(int prefixo, int sufixo) {
        this.prefixo = prefixo;
        this.sufixo = Integer.valueOf(sufixo).shortValue();
    }

    public static Cep vazio() {
        return VAZIO;
    }

    public static Cep valueOf(String text) {
        text = Strings.nullToEmpty((String)text).trim();
        Matcher matcher = regex.matcher(text);
        Cep.checkArgument(matcher.matches(), "CEP deve estar no format xxxxx-xxx", new Object[0]);
        String _prefixo = matcher.group(1);
        String _sufixo = matcher.group(2);
        int prefixo = Integer.valueOf(_prefixo, 10);
        short sufixo = Short.valueOf(_sufixo, 10);
        return new CepPadrao(prefixo, sufixo);
    }

    public static Cep valueOf(int val) {
        int temp = val;
        int sufixo = val % 1000;
        int prefixo = temp /= 1000;
        return new CepPadrao(prefixo, sufixo);
    }

    private static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new ExcecaoDeCepInvalido(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public int getPrefixo() {
        return this.prefixo;
    }

    public int getSufixo() {
        return this.sufixo;
    }

    public String toString() {
        return String.format("%05d-%03d", this.prefixo, this.sufixo);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.prefixo;
        result = 31 * result + this.sufixo;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cep)) {
            return false;
        }
        Cep other = (Cep)obj;
        if (this.prefixo != other.prefixo) {
            return false;
        }
        return this.sufixo == other.sufixo;
    }

    private static class CepVazio
    extends Cep {
        public CepVazio() {
            super(0, 0);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    private static class CepPadrao
    extends Cep {
        public CepPadrao(int prefixo, int sufixo) {
            super(prefixo, sufixo);
            Cep.checkArgument(prefixo >= 0, "Prefixo deve ser positivo", new Object[0]);
            Cep.checkArgument(prefixo < 100000, "Prefixo deve ser um n\u00famero entre 0 e 99999", new Object[0]);
            Cep.checkArgument(sufixo >= 0, "Sufixo deve ser um n\u00famero entre 0 e 999", new Object[0]);
            Cep.checkArgument(sufixo < 1000, "Sufixo deve ser um n\u00famero entre 0 e 999", new Object[0]);
        }
    }
}

