/*
 * Copyright 2016 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.tftp;

import java.util.List;

import br.com.objectos.rio.udp.Packet;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class OptionsFullReadSession extends ReadSession {

  private final OAckMessage ackMessage;
  private AckProcessor processor = new BlockZeroAckProcessor();

  public OptionsFullReadSession(Packet packet, OAckMessage ackMessage, List<DataMessage> messageList) {
    super(packet, messageList);
    this.ackMessage = ackMessage;
  }

  @Override
  AckProcessor ackProcessor() {
    return processor;
  }

  @Override
  void executeStart(TftpServer server) {
    reply(ackMessage);
    server.onOAckSent(ackMessage);
  }

  private class BlockZeroAckProcessor extends AckProcessor {

    @Override
    ReadSessionOnAck onMessage(AckMessage message) {
      sendCurrent();
      processor = new AckProcessor();
      return ReadSessionOnAck.noop();
    }

  }

}