/*
 * Copyright 2016 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.tftp;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
abstract class ReadSessionOnAck {

  private static final ReadSessionOnAck NOOP = new Noop();

  ReadSessionOnAck() {
  }

  public static ReadSessionOnAck noop() {
    return NOOP;
  }

  public static ReadSessionOnAck unregister(ReadSession session) {
    return new Unregister(session);
  }

  public abstract void execute(TftpServer server);

  private static class Noop extends ReadSessionOnAck {

    @Override
    public void execute(TftpServer server) {
      // noop
    }

  }

  private static class Unregister extends ReadSessionOnAck {

    private final ReadSession session;

    public Unregister(ReadSession session) {
      this.session = session;
    }

    @Override
    public void execute(TftpServer server) {
      server.unregister(session);
    }

  }

}