/*
 * Copyright 2016 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.tftp;

import java.util.Objects;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class TftpServerBuilder {

  private int port;

  public TftpServerBuilderDsl localhost(int port) {
    this.port = port;
    return new Dsl();
  }

  private class Dsl
      implements
      TftpServerBuilderDsl,
      TftpServerBuilderDsl.DataProviderDsl {

    private DataProvider dataProvider;

    @Override
    public TftpServer build() {
      return new TftpServer(port, dataProvider);
    }

    @Override
    public DataProviderDsl dataProvider(DataProvider provider) {
      dataProvider = Objects.requireNonNull(provider);
      return this;
    }

  }

}